import java.awt.*;
import java.awt.event.*;
import java.util.*;
import java.io.*;
import java.applet.*;
import java.net.*;

public class ConverterGUIApplet extends Applet 
             implements ActionListener, ItemListener{

  /* The Converter Program     by J M Bishop  Dec 1998
   * ---------------------     Display version July 1999
   *                           GUI version July 1999
   *                           Applet version July 1999    //---
   * Keeps the exchange rates from one currency into
   * many others and enables currency exchanges to be
   * estimated.
   *
   * Illustrates the use of a simple GUI running as //---
   * an applet with a connection to a home file.  //---
   */

  
    Hashtable table = new Hashtable();
      
    Rates rate;
    Choice fromChoice, toChoice;
    boolean fromSelected, toSelected;
    TextField amountField;
    TextArea resultField;
    int amount = 1000;
    String toCountry, fromCountry;
    Button goButton;
    
    public void init () {
      Panel p = new Panel (new BorderLayout());
      
        // left hand side panel
        Panel q = new Panel();
          q.add ("North",new Label ("From"));
          fromChoice = new Choice();
            fromChoice.addItemListener (this);
            q.add("Center",fromChoice);
          p.add ("West", q);
        // right hand side panel
        q = new Panel();
          q.add ("North",new Label ("To"));
          toChoice = new Choice();
            toChoice.addItemListener (this);
            q.add("Center",toChoice);
          p.add ("East",q);
        // Centre panel
        q = new Panel(new BorderLayout());
          Panel r = new Panel();
            r.add(new Label("Amount"));
            amountField = new TextField("1000  ");
            amount = 1000;
              amountField.addActionListener(this);
              r.add(amountField);
              q.add("North",r);
            resultField = new TextArea(8,20);
              q.add ("Center",resultField);
              resultField.append("First select the countries\n");  //---
            goButton = new Button ("Convert");
              goButton.addActionListener(this);
              q.add("South",goButton);
          p.add("Center",q);
      add(p);
      readIn();
    }
    
    public void actionPerformed (ActionEvent e) {
      // Get the latest amount
      amount = (int) Integer.parseInt(amountField.getText().trim());
      
      if (e.getSource() == goButton) {
        if (fromSelected && toSelected)
          transaction();
        else
          resultField.append("First select the countries\n");
      }
    }
    
    public void itemStateChanged(ItemEvent e) {
      String s = (String) e.getItem();
      if (e.getItemSelectable() == fromChoice) {
        fromSelected = true;
        fromCountry = s;
      }
      else {
        toSelected = true;
        toCountry = s;
      }
    }
    
    void transaction () {
      Rates fromRate = (Rates) table.get(fromCountry);
      Rates toRate = (Rates) table.get(toCountry);
      resultField.append(amount+" "+fromRate.country+" "+
          fromRate.currency+
          "\n in "+toRate.country+" "+toRate.currency+"\n was "+
          Text.format(amount/fromRate.conversion*
                      toRate.conversion,10,3)
          +"\n\n");
    } 
    
  void readIn() {
    try {
      // Setting up access to the rates file via the internet
      URL ratesFileURL = new URL(getCodeBase()+"rates.data");
      URLConnection con = ratesFileURL.openConnection();
      BufferedReader fin = null;
      try {
        fin = new BufferedReader(new InputStreamReader
              (con.getInputStream()));
      }
      catch (IOException e) {
        resultField.append("rates.data file not found\n");
      }
      
      try {
        for (int i = 0; ; i++) {
          rate = new Rates();
          rate.setRate(fin);
          table.put(rate.country, rate);
          toChoice.addItem(rate.country);
          fromChoice.addItem(rate.country);
        }
      }
      catch (EOFException e) {}
    }
    catch (Exception e) {
      resultField.append("Could not read the data\n");
    }
    fromSelected = false;
    toSelected = false;
  }
  
}

