/*
 * Decompiled with CFR 0.152.
 */
package javagently;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import javagently.Graph;
import javagently.Text;

public class Display
extends Frame
implements ActionListener {
    private String title;
    private Hashtable table = new Hashtable(10);
    private int xwidth;
    private int yheight;
    private Button okButton;
    private Button closeButton;
    private TextArea outDisplay;
    private Panel inDisplay;
    private ScrollPane inPane;
    private ScrollPane outPane;
    private Watcher okWatcher = new Watcher();
    private boolean graphInFront;
    private Graph graph;

    public Display(String string) {
        this.title = string;
        this.initializeDisplay();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.okButton) {
            this.okWatcher.ready();
        } else if (actionEvent.getSource() == this.closeButton) {
            System.exit(0);
        }
    }

    public double getDouble(String string) {
        Data data = this.getEntry(string);
        return Double.valueOf(data.value);
    }

    private Data getEntry(String string) {
        if (this.table.containsKey(string)) {
            return (Data)this.table.get(string);
        }
        this.outDisplay.append("\nERROR: No such input label: " + string + "\n");
        return null;
    }

    public int getInt(String string) {
        Data data = this.getEntry(string);
        return Integer.valueOf(data.value);
    }

    public String getString(String string) {
        Data data = this.getEntry(string);
        return data.value;
    }

    private void initializeDisplay() {
        this.xwidth = 640;
        this.yheight = 480;
        ((Component)this).setSize(this.xwidth, this.yheight);
        this.setTitle(this.title);
        this.setLayout(new BorderLayout());
        Panel panel = new Panel();
        panel.add(new Label("INPUT"));
        panel.add(new Label("OUTPUT"));
        this.add((Component)panel, "North");
        panel = new Panel(new FlowLayout(1, 15, 0));
        this.inPane = new ScrollPane(1);
        this.inPane.setSize(this.xwidth / 2 - 40, this.yheight - 100);
        this.inDisplay = new Panel(new GridLayout(0, 2, 10, 10));
        this.inPane.add(this.inDisplay);
        panel.add(this.inPane);
        this.outDisplay = new TextArea(24, 40);
        panel.add(this.outDisplay);
        this.add((Component)panel, "Center");
        panel = new Panel(new BorderLayout());
        this.okButton = new Button("Ready");
        this.okButton.addActionListener(this);
        this.okButton.setEnabled(false);
        panel.add("Center", this.okButton);
        this.closeButton = new Button("Close");
        this.closeButton.addActionListener(this);
        this.closeButton.setEnabled(true);
        panel.add("East", this.closeButton);
        this.add("South", panel);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        ((Component)this).setVisible(true);
        this.graphInFront = false;
    }

    private void insertPrompt(Data data, String string, TextField textField) {
        Panel panel = new Panel(new FlowLayout(2));
        panel.add(new Label(string));
        this.inDisplay.add(panel);
        textField.addActionListener(this);
        textField.setEditable(true);
        panel = new Panel(new FlowLayout(0));
        panel.add(textField);
        this.inDisplay.add(panel);
        data.field = textField;
    }

    public void println(String string) {
        this.outDisplay.append(String.valueOf(string) + "\n");
    }

    public void prompt(String string, double d) {
        Data data = new Data();
        TextField textField = new TextField(10);
        this.insertPrompt(data, string, textField);
        data.value = Double.toString(d);
        textField.setText(data.value);
        this.table.put(string, data);
    }

    public void prompt(String string, int n) {
        Data data = new Data();
        TextField textField = new TextField(10);
        this.insertPrompt(data, string, textField);
        data.value = Text.writeInt(n, 0);
        textField.setText(data.value);
        this.table.put(string, data);
    }

    public void prompt(String string, String string2) {
        Data data = new Data();
        TextField textField = new TextField(string2.length() + 2);
        this.insertPrompt(data, string, textField);
        data.value = string2;
        textField.setText(data.value);
        this.table.put(string, data);
    }

    public void ready(String string) {
        this.outDisplay.append(String.valueOf(string) + "\n");
        this.okButton.setEnabled(true);
        ((Component)this).setVisible(true);
        if (this.graphInFront) {
            this.graph.toFront();
        }
        this.okWatcher.watch();
        Enumeration enumeration = this.table.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            Data data = (Data)this.table.get(string2);
            data.value = data.field.getText();
            this.table.put(string2, data);
        }
    }

    public void reposition(Graph graph) {
        ((Component)graph).setLocation(30, this.yheight / 2 - 30);
        ((Component)graph).setSize(this.xwidth / 2 - 40, this.yheight / 2 - 15);
        this.graphInFront = true;
        this.graph = graph;
    }

    private class Data {
        TextField field;
        String value;

        Data() {
        }
    }

    class Watcher {
        private boolean ok = false;

        Watcher() {
        }

        synchronized void ready() {
            this.ok = true;
            this.notify();
        }

        synchronized void watch() {
            while (!this.ok) {
                try {
                    this.wait(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.ok = false;
        }
    }
}

