import java.applet.*;
import java.net.*;
import java.util.*;
import java.awt.*;
import java.awt.event.*;

public class Orbit extends Applet implements ActionListener {

/*  Applet to draw the orbit of a planet
 *  -------------------------------------  N T Bishop and
 *                                         J M Bishop Dec 1998 
 *
   INPUT DATA to be fetched from the web page

   NAME  DESCRIPTION     TYPE        UNITS
   a     semi-major axis real        AU %(*)
   ep    eccentricity    real        dimensionless
   p     period          real        year [of Earth]
   planetName            string

  * 1AU is 1 Astronomical Unit, and is defined as the semi-major 
  * axis of the Earth's orbit. It is approximately 150 million km.
  */

  static final int    n  = 100;       // number of angular grid-points
  static final double ddt= 0.02;      // time-step [unit: year of planet]
  static final double pi = Math.PI;
  static final int    limitxy = 300;  //n could be made larger, 
                                      //and ddt could be made smaller, 
                                      //if more accuracy is needed. 
  double a, ep, p, dt,
         d, t, th,
         torbit, tfrac, r;
  double tref [] = new double [2*n+1];
  int    ith, norbit, tyear, x, y, newx, newy;
  String planetName;

  private Canvas area;
  private OrbitCanvas orbit;
  private Button startButton;
  private TextField orbitBox, yearBox;

  public void init () {
    initialiseData();
  area = new Canvas();
    orbit = new OrbitCanvas(this,area);
    add ("Center", orbit);
    Panel p = new Panel ();      
    startButton = new Button("Start");
      startButton.addActionListener(this);
      p.add(startButton);
      p.add(new Label ("Orbits"));
      orbitBox = new TextField(4);
      p.add(orbitBox);
      p.add (new Label("Years"));
      yearBox = new TextField(7);
      p.add(yearBox);
    add ("South", p);
  }

  private void initialiseData() {
    // These parameters come from the web page
  planetName = getParameter("name");
    a          = getParameter("axis");
    ep         = getParameter("eccentricity");
    p          = getParameter("period");
    t=0.0;
    tyear=0;
    tfrac=0.0;
    torbit=0.0;
    norbit=0;
    ith=0;
    dt=ddt*p;
    x=scalex((1-ep*ep)/(1+ep));
    y=scaley(0.0);
    d=Math.sqrt(1-ep*ep);
    tref[0]=0.0;
    tref[n]=p/2;
    tref[2*n]=p;

    for (int i=1; i< n; i++) {
      th=i*pi/n;
      tref[i]=p/(2*pi)*(2*Math.atan(Math.tan(th/2)*(1-ep)/d)
                       -d*ep*Math.sin(th)/(1+ep*Math.cos(th) ) );
      tref[2*n-i]=p-tref[i];
    }
  }

  public void actionPerformed (ActionEvent e) {
    // There is only a StartButton
    orbit.start();
  }

  int scalex (double coord) {
    return (int) (limitxy*coord/4.0+limitxy/2.0);
  }

  int scaley (double coord) {
    return (int) (-limitxy*coord/4.0+limitxy/3.0);
  }

  class OrbitCanvas extends Thread {

    private Applet weAre;
    private Canvas area;
  
    OrbitCanvas (Applet app, Canvas can) {
    weAre = app;
    area = can;
    }

    public void run () {
      Graphics g = area.getGraphics();
      g.setColor(Color.yellow);
      g.fillOval(scalex(0)-8,scaley(0)-8,16,16);
      while (true) {
        t=t+dt;
        tyear=(int) t;
        tfrac=t - tyear;
        torbit=torbit+dt;
        if (torbit > p) {
          torbit=torbit-p;
          norbit=norbit+1;
          ith=0;
        }

        while (torbit > tref[ith+1])
          ith=ith+1;
  
        th=ith*pi/n + (torbit-tref[ith])*pi/n/(tref[ith+1]-tref[ith]);
        r=(1-ep*ep)/(1+Math.cos(th)*ep);
        newx=scalex(r*Math.cos(th));
        newy=scaley(r*Math.sin(th));
        g.setColor(Color.black);
        g.drawLine (x,y,newx,newy);
        g.setColor(Color.white);
        g.fillOval(x-1,y-1,3,3);
        g.setColor(Color.red);
        g.fillOval(newx-1,newy-1,3,3);
        x = newx;
        y = newy; 
        orbitBox.setText(String.valueOf(norbit));
        yearBox.setText(String.valueOf(t));

        try { sleep(500);}
        catch(InterruptedException e) { }
      }
    }  
  }

}

