/*
 * Decompiled with CFR 0.152.
 */
package javagently;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javagently.List;
import javagently.Text;

public class Graph
extends Frame {
    private String xAxisTitle;
    private String yAxisTitle;
    private String graphTitle;
    private boolean keys;
    private List points;
    private List datasets;
    private double xSpread;
    private double ySpread;
    private double xMin;
    private double xMax;
    private double yMin;
    private double yMax;
    private int xAxisLength;
    private int yAxisLength;
    private int xOrigin;
    private int yOrigin;
    private int xBorder;
    private int yBorder;
    private static final int cs = 3;
    public final int red = 3;
    public final int blue = 2;
    public final int magenta = 1;
    public final int black = 0;

    public Graph() {
        this.initializeGraph();
        this.xAxisTitle = "";
        this.yAxisTitle = "";
        this.graphTitle = "";
    }

    public Graph(String string, String string2, String string3) {
        this.initializeGraph();
        this.graphTitle = string;
        this.xAxisTitle = string2;
        this.yAxisTitle = string3;
    }

    public void add(double d, double d2) {
        this.points.add(new Point(d, d2));
        ++((Dataset)this.datasets.current()).count;
        if (d > this.xMax) {
            this.xMax = d;
        }
        if (d < this.xMin) {
            this.xMin = d;
        }
        if (d2 > this.yMax) {
            this.yMax = d2;
        }
        if (d2 < this.yMin) {
            this.yMin = d2;
        }
    }

    private void changeColor(Graphics graphics, int n) {
        switch (n) {
            case 0: {
                graphics.setColor(Color.black);
                break;
            }
            case 1: {
                graphics.setColor(Color.magenta);
                break;
            }
            case 2: {
                graphics.setColor(Color.blue);
                break;
            }
            case 3: {
                graphics.setColor(Color.red);
                break;
            }
        }
    }

    private void drawAxes(Graphics graphics) {
        Font font = graphics.getFont();
        Font font2 = new Font(font.getFamily(), 0, 10);
        Font font3 = new Font(font.getFamily(), 1, 14);
        graphics.drawLine(this.xBorder - 5, this.yOrigin, this.xAxisLength + this.xBorder + 5, this.yOrigin);
        graphics.drawLine(this.xOrigin, this.yBorder - 5, this.xOrigin, this.yAxisLength + this.yBorder + 5);
        graphics.drawString(this.xAxisTitle, this.getWidth() - graphics.getFontMetrics().stringWidth(this.xAxisTitle) - this.xBorder / 2, this.yOrigin - 5);
        graphics.drawString(this.yAxisTitle, this.xOrigin - graphics.getFontMetrics().stringWidth(this.yAxisTitle) / 2, this.yBorder - 8);
        graphics.setFont(font3);
        graphics.drawString(this.graphTitle, (this.getWidth() - graphics.getFontMetrics().stringWidth(this.graphTitle)) / 2, this.yBorder / 2);
        graphics.setFont(font);
        if (this.keys) {
            this.drawTitles(graphics);
        }
        int n = this.scaleX(this.xMin);
        int n2 = this.scaleX(this.xMax);
        int n3 = this.scaleY(this.yMin);
        int n4 = this.scaleY(this.yMax);
        graphics.drawLine(this.xOrigin - 5, n4, this.xOrigin + 5, n4);
        graphics.drawLine(this.xOrigin - 5, n3, this.xOrigin + 5, n3);
        graphics.drawLine(n2, this.yOrigin + 5, n2, this.yOrigin);
        graphics.drawLine(n, this.yOrigin + 5, n, this.yOrigin);
        graphics.setFont(font2);
        graphics.drawString(Text.writeDouble(this.xMin, 6, 2), n - 10, this.yOrigin + 15);
        graphics.drawString(Text.writeDouble(this.xMax, 6, 2), n2 - 10, this.yOrigin + 15);
        graphics.drawString(Text.writeDouble(this.yMin, 6, 2), this.xOrigin - 35, n3 + 4);
        graphics.drawString(Text.writeDouble(this.yMax, 6, 2), this.xOrigin - 35, n4 + 4);
        graphics.setFont(font);
    }

    private void drawSymbol(Graphics graphics, int n, int n2, int n3) {
        switch (n) {
            case 0: {
                graphics.drawOval(n2 - 3, n3 - 3, 6, 6);
                break;
            }
            case 1: {
                graphics.drawPolygon(this.trix(n2), this.uptriy(n3), 3);
                break;
            }
            case 2: {
                graphics.drawPolygon(this.trix(n2), this.triy(n3), 3);
                break;
            }
            case 3: {
                graphics.drawRect(n2 - 3, n3 - 3, 6, 6);
                break;
            }
        }
    }

    private void drawTitles(Graphics graphics) {
        int n = this.xBorder;
        int n2 = this.getHeight() - this.yBorder / 2;
        this.datasets.reset();
        boolean bl = this.datasets.eol();
        while (!bl) {
            Dataset dataset = (Dataset)this.datasets.current();
            if (dataset.colorRequired) {
                this.changeColor(graphics, dataset.plotType);
            }
            if (dataset.symbolRequired) {
                this.drawSymbol(graphics, dataset.plotType, n, n2 - 3);
                n += 12;
            }
            graphics.drawString(dataset.title, n, n2);
            n += graphics.getFontMetrics().stringWidth(dataset.title) + 20;
            bl = this.datasets.eol();
            if (bl) continue;
            this.datasets.succ();
        }
        graphics.setColor(Color.black);
    }

    private void initializeGraph() {
        this.datasets = new List();
        this.nextGraph();
        this.points = new List();
        this.xMax = this.yMax = Double.MIN_VALUE;
        this.yMin = Double.MAX_VALUE;
        this.xMin = Double.MAX_VALUE;
        this.keys = false;
        ((Component)this).setSize(640, 480);
        super.setTitle("Graph");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Graph.this.dispose();
            }
        });
    }

    public void nextGraph() {
        Dataset dataset = new Dataset();
        dataset.count = 0;
        dataset.plotType = 0;
        dataset.title = "";
        dataset.symbolRequired = false;
        dataset.colorRequired = false;
        dataset.titleRequired = false;
        dataset.lineRequired = true;
        this.datasets.add(dataset);
    }

    public void paint(Graphics graphics) {
        this.xBorder = 40;
        this.yBorder = 80;
        this.xAxisLength = this.getWidth() - 2 * this.xBorder;
        this.yAxisLength = this.getHeight() - 2 * this.yBorder;
        this.xSpread = this.xMax - this.xMin;
        this.ySpread = this.yMax - this.yMin;
        this.xOrigin = this.xMin > 0.0 ? this.scaleX(this.xMin) : this.scaleX(0.0);
        this.yOrigin = this.yMin > 0.0 ? this.scaleY(this.yMin) : this.scaleY(0.0);
        this.drawAxes(graphics);
        this.plotGraphs(graphics);
    }

    private void plotGraphs(Graphics graphics) {
        this.datasets.reset();
        this.points.reset();
        boolean bl = this.datasets.eol();
        do {
            Dataset dataset = (Dataset)this.datasets.current();
            if (dataset.colorRequired) {
                this.changeColor(graphics, dataset.plotType);
            }
            Point point = (Point)this.points.current();
            int n = this.scaleX(point.xCoord);
            int n2 = this.scaleY(point.yCoord);
            if (dataset.symbolRequired) {
                this.drawSymbol(graphics, dataset.plotType, n, n2);
            }
            int n3 = 1;
            while (n3 < dataset.count) {
                this.points.succ();
                Point point2 = (Point)this.points.current();
                int n4 = this.scaleX(point2.xCoord);
                int n5 = this.scaleY(point2.yCoord);
                if (dataset.lineRequired) {
                    graphics.drawLine(n, n2, n4, n5);
                }
                if (dataset.symbolRequired) {
                    this.drawSymbol(graphics, dataset.plotType, n4, n5);
                }
                n = n4;
                n2 = n5;
                ++n3;
            }
            bl = this.datasets.eol();
            if (bl) continue;
            this.datasets.succ();
            this.points.succ();
        } while (!bl);
    }

    private int scaleX(double d) {
        return (int)((d - this.xMin) / this.xSpread * (double)this.xAxisLength) + this.xBorder;
    }

    private int scaleY(double d) {
        return (int)((double)this.yAxisLength - (d - this.yMin) / this.ySpread * (double)this.yAxisLength) + this.yBorder;
    }

    public void setColor(int n) {
        ((Dataset)this.datasets.current()).colorRequired = true;
        ((Dataset)this.datasets.current()).plotType = n;
    }

    public void setLine(boolean bl) {
        ((Dataset)this.datasets.current()).lineRequired = bl;
        if (!bl) {
            ((Dataset)this.datasets.current()).symbolRequired = true;
        }
    }

    public void setSymbol(int n) {
        ((Dataset)this.datasets.current()).symbolRequired = true;
        ((Dataset)this.datasets.current()).plotType = n;
    }

    public void setSymbol(boolean bl) {
        ((Dataset)this.datasets.current()).symbolRequired = bl;
    }

    public void setTitle(String string) {
        ((Dataset)this.datasets.current()).titleRequired = true;
        ((Dataset)this.datasets.current()).title = string;
        this.keys = true;
    }

    public void showGraph() {
        this.repaint();
        ((Component)this).setVisible(true);
    }

    private int[] trix(int n) {
        int[] nArray = new int[]{n - 3, n + 3, n};
        return nArray;
    }

    private int[] triy(int n) {
        int[] nArray = new int[]{n + 3, n + 3, n - 3};
        return nArray;
    }

    private int[] uptriy(int n) {
        int[] nArray = new int[]{n - 3, n - 3, n + 3};
        return nArray;
    }

    private class Dataset {
        int count;
        int plotType;
        String title;
        boolean colorRequired;
        boolean symbolRequired;
        boolean titleRequired;
        boolean lineRequired;

        Dataset() {
        }
    }

    private class Point {
        double xCoord;
        double yCoord;

        Point(double d, double d2) {
            this.xCoord = d;
            this.yCoord = d2;
        }
    }
}

