package jgeslib;

public class Complex {

  /* Complex numbers class       J M Bishop 1990
   * ---------------------       Java A Moolman 1999
   */
  
  public double re;
  public double im;

  public Complex(double r, double i) {
    re = r;
    im = i;
  }

  public Complex(double r) {
    re = r;
    im = 0;
  }

  public Complex() {
    re = 0;
    im = 0;
  }

  public static Complex add(Complex a, Complex b) {
    Complex c = new Complex();
    c.re = a.re + b.re;
    c.im = a.im + b.im;
    return c;
  }
  
  public static Complex mult(Complex a, Complex b) {
    Complex c = new Complex();
    c.re = a.re*b.re - a.im*b.im;
    c.im = a.re*b.im + a.im*b.re;
    return c;
  }

  public static Complex div(Complex a, Complex b) {
    Complex c = new Complex();
    c.re = (a.re*b.re + a.im*b.im)/(b.re*b.re + b.im*b.im);
    c.im = (b.re*a.im - b.im*a.re)/(b.re*b.re + b.im*b.im);
    return c;
  }

  public static Complex sub(Complex a, Complex b) {
    Complex c = new Complex();
    c.re = a.re - b.re;
    c.im = a.im - b.im;
    return c;
  }

  public double abs () {
    return Math.sqrt(re*re + im*im);
  }
}
