package jgeslib;

public abstract class ComplexNewtonRaphson {

  /* A Newton-Raphson solver for complex numbers    NT and JM Bishop
   * -------------------------------------------    July 1999
   * Uses methods from class complex.
   */

  public abstract Complex f (Complex x);
  public abstract Complex df (Complex x);
  public int iteration;
  public Complex estimate [];
  
  public void solve (Complex xnew, double tolerance, int imax) {
                   
    estimate = new Complex[imax+1];
    Complex xold;
    Complex temp;
    estimate[0] = xnew;
    iteration = 0;
     do {
        iteration++;
        xold = xnew;
        temp = Complex.div (f(xold), df(xold));
        xnew = Complex.sub(xold, temp);
        estimate[iteration]=xnew;
        temp = Complex.sub(xnew,xold);
      } while (temp.abs() > tolerance & iteration < imax);
  }
}