package jgeslib;

public abstract class Integrate {

  /* Integrating a function class      by NT Bishop  1990, 1999
   * -------------------------
   *
   * Extend the method and supply the function f.
   * Integrate by Simpson's rule from a to b with 
   * n strips (n must be EVEN).
   * Result is the value of the method.
   */


  public abstract double f (double x);
  
  public double integrate (double a, double b, int n) {
    double h = (b-a)/n;
    double s1 = 0;
    double s2 = 0;
    double x = a;

    for (int i=1; i<n; i++) {
      x+=h;
      if(i%2==1) 
        s1 += f(x);
      else       
        s2 += f(x);
    }
    return (h/3*(f(a) + 4*s1 + 2*s2 + f(b)));
  }
}
  
