package jgeslib;

public class LeastSquares {

  /* The self-contained Least Squares class   by J M bnd N T Bishop
   * ======================================      July 1999
   *
   * provides a means for fitting a least squares
   * line to a set of data points. The results are
   * available in the variables a and b
   */

  public double a,b;

  public void solve (double x [], double y [], int n) {
    double D = (n*sumtwo(x,x,n)-Math.pow(sumone(x,n),2));
    a = (sumtwo(x,x,n)*sumone(y,n) -
         sumtwo(x,y,n)*sumone(x,n))/D;
    b = (n*sumtwo(x,y,n)-sumone(x,n)*sumone(y,n))/D;
  }

  private double sumone (double u [], int n) {
    double sofar = 0;
    for (int i=0; i<n; i++)
      sofar += u[i];
    return sofar;
  }

  private double sumtwo (double u [], double v [], int n) {
    double sofar = 0;
    for (int i=0; i<n; i++)
      sofar += u[i]*v[i];
    return sofar;
  }
}
