package jgeslib;

public abstract class NewtonRaphson {

  /* Newton-Raphson solver         JM and NT Bishop
   * ---------------------         July 1999
   * 
   * To extend the class, supply versions of f and df
   * To make use of it, call solve.
   * The root is available in estimate[iteration]
   * The earlier values of the estimation can also be
   * examined, as can iteration
   */

  public abstract double f (double x);
  public abstract double df (double x);

  public int iteration;
  public double estimate [];
  
  public void solve (double xnew, double tolerance, int imax) {
                   
    estimate = new double[imax+1];
    double xold;
    estimate[0] = xnew;
    iteration = 0;
     do {
        iteration++;
        xold = xnew;
        xnew = xold - f(xold) / df(xold);
        estimate[iteration]=xnew;
      } while (Math.abs(xnew - xold) > tolerance & iteration < imax);
  }
}
