package jgeslib;

public abstract class PredictorCorrector {

  /* Preidctor-Corrector method     N T Bishop 1990
   * --------------------------     J M Bishop, N T Bishop 1999
   *
   * Integrates up to two first-order
   * differential equations
   * Extend by supplying the two equations in fA and fB
   * The result is in estimateB[reports]
   * Intemediate results acn also be examined
   */

  public abstract double fA (double x, double yA, double yB);
  public abstract double fB (double x, double yA, double yB);

  public double estimateA [];
  public double estimateB [];
  public double estimatex [];
  
  public void solve (double x, 
              double yA,
              double yB,
              double h,
              int imax,
              int reports) {
    double yAp, yBp;       
    estimateA = new double[reports+1];
    estimateB = new double[reports+1];
    estimatex = new double[reports+1];
    
    estimateA[0] = yA; estimateB[0] = yB; estimatex[0] = x;
    for(int i=1; i<=reports; i++) {
      for(int j=1; j<=imax; j++) {
        yAp = yA + h*fA(x,yA,yB);
        yBp = yB + h*fB(x,yA,yB);
        yA = yA + 0.5*h*(fA(x,yA,yB) + fA(x+h,yAp,yBp));
        yB = yB + 0.5*h*(fB(x,yA,yB) + fB(x+h,yAp,yBp));
        x += h;
      }
      estimateA[i] = yA;
      estimateB[i] = yB;
      estimatex[i] = x;
    }
 }
}