package jgeslib;

public class SORSolver {

  /* Successive over relaxation solver    N T Bishop 1990, 1999
   * =================================
   * 
   * The solve routine needs seven parameters. The
   * results are available in 3 public variables.
   */

  public double xnew [];
  public boolean convergence;
  public int iterations;
  
  public void solve (double a [][], double b [], double x [], 
                    int n, double omega, double tolerance, 
                    int kmax) {

    xnew = new double [n];
	convergence = false;
	iterations = 0;
    double xold [] = x;
    do {
      for (int i=0; i<n; i++) {
        double sumax = 0;
        double sumaxold = 0;
        for (int j=0; j<i; j++) 
          sumax += a[i][j]*xnew[j];
        for (int j=i+1; j<n; j++) 
          sumaxold += a[i][j]*xold[j];
        xnew[i] = (1-omega) * xold[i] -
        omega*(sumax + sumaxold - b[i]) / a[i][i];
      }
      iterations++;
      if (normLinfinity(xold, xnew, n) < tolerance) 
        convergence = true;
      for (int j=0; j<n; j++) 
        xold[j] = xnew[j];
    } while ((!convergence) & !(iterations==kmax));
  }

  public double normLinfinity(double [] x, double [] y, int n) {
    double highest = Math.abs(x[1]-y[1]);
    for (int i=0; i<n; i++)
      if (Math.abs(x[i]-y[i]) > highest) 
        highest = Math.abs(x[i]-y[i]);
    return highest;
  }
}


