package jgeslib;

public abstract class Secant {

  /* Root finding by the secant method    by N T Bishop, 1990, 1999
   * ---------------------------------
   * 
   * To extend the class, supply the function, f
   * Then call solve.
   * The root will be in estimate[iteration]
   * Earlier estimates are also available
   */

  public abstract double f (double x);
  
  public int iteration;
  public double estimate [];
  
  public void solve (double x1, 
              double x2,
              double tolerance,
              int imax) {
                   
    estimate = new double[imax+1];
    double f1, f2;
    double x;
    
    f1 = f(x1);
    estimate[0] = x1;
    estimate[1] = x2;
    x = x2;
    iteration = 1;
    do {
      x2 = x1;
      x1 = x;
      f2 = f1;
      f1 = f(x1);
      x = (x1*f2 - x2*f1) / (f2-f1);
      iteration ++;
      estimate[iteration] = x;
    } while ( (Math.abs(x-x1) > tolerance) & (iteration < imax));
  }
}